/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*
* \file main.c
*
* \brief Diagnostic test main file
*
******************************************************************************/

#include "platform.h"
#include <string.h>

#define	MAX_LEN	200
#define READ_DELAY   (30000000)

static WRITE_info write_type = PLATFORM_WRITE_UART;
static READ_info read_type = PLATFORM_READ_UART;

static char	write_buffer[MAX_LEN];

static INT32 uart_timeout = 30000000;

INT32 platform_write(const char *fmt, ... )
{
	va_list 	    arg_ptr;
	unsigned int	i, length;
	UART_Handle uart0;

	/* Initial platform_write to temporary buffer.. at least try some sort of sanity check so we don't write all over
	 * memory if the print is too large.
	 */
	if (strlen(fmt) > MAX_LEN)
		return -1;

	/* Open Uart Handle */
	    if ( ( uart0 = _UART_open( UART_0, /*115200*/ 26 ) ) == 0 )
	        return -1;

	va_start( arg_ptr, fmt );
	length = vsprintf( (char *)write_buffer, fmt, arg_ptr );
	va_end( arg_ptr );

	if ((write_type == PLATFORM_WRITE_UART) || (write_type == PLATFORM_WRITE_ALL))
	{
		for (i=0; i < length; i++) {
			if (write_buffer[i] == '\n') {
				uart_send(uart0, (unsigned char)0x0D, uart_timeout);
				uart_send(uart0, (unsigned char)0x0A, uart_timeout);
			}
			else {
				uart_send(uart0, (unsigned char)write_buffer[i], uart_timeout);
			}
		}
	}

	if ((write_type == PLATFORM_WRITE_PRINTF) || (write_type == PLATFORM_WRITE_ALL))
	{
		/*Used to print on the CCS console*/
		printf("%s", write_buffer);
		fflush(stdout);
	}
	DM388_usecDelay(1000);
	return 0;
}

INT32 platform_read(UINT8 *data, UINT32 length)
{
	INT32 status = 0;
	UINT32 count = 0;
	UART_Handle uart0;

	/* Open Uart Handle */
		    if ( ( uart0 = _UART_open( UART_0, /*115200*/ 26 ) ) == 0 )
		        return -1;

	if (read_type == PLATFORM_READ_UART)
	{
		/* Wait till an input is provided */
		do
		{
		status = uart_recv (uart0, data, uart_timeout);//
		if(status == 0)
		{
			/* Check if user pressed enter */
			if((*data == 0xD) || (*data == 0x1B))
			{
			   *data = '\0';
			   break;
			}

			uart_send(uart0, *data, uart_timeout);

			count++;
			data++;
		}
		else
		{
			platform_write("UART read error");
			return -1;
		}
		} while ((status != 0) || (count != length));
	}

	if (read_type == PLATFORM_READ_SCANF)
		{
			count = scanf("%s", data);
		}

return (count);
}
